              
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                                                                            *
*  Project    : AN3815 - MC56F8006 Modular Pixel Matrix                      *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Authors    : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: protocol_manager.c                                                  *
*                                                                            *
*    Interpret serial communication protocol between the pixel boards and    *
*    its network master.                                                     *
*                                                                            *
******************************************************************************/


/************************* Include Files *************************************/
#include "util.h"
#include "protocol_manager.h"
#include "sci.h"
#include "gpio.h"
#include "pwm.h"
#include "color_manager.h"

/******************************** Prototypes *********************************/

void protocolm_init(void);
void protocolm_task(void);

/******************************** Variables **********************************/

//! Desired red color value received from network master on SCI.
uint8_t red_value;
//! Desired green color value received from network master on SCI.
uint8_t green_value;
//! Desired blue color value received from network master on SCI.
uint8_t blue_value;

//! State machine variable
PM_STATE_MACHINE protocolm_state_machine;

//! Auxiliary variable to store color data from SCI. 
uint8_t flag_color;

/*********************** Function's Implementation ***************************/


//! Initializes protocol manager local variables.
/*! This function should be called before "protocolm_task()"*/
void protocolm_init(void)
{
    protocolm_state_machine = PM_IDLE;
    red_value =0;
    green_value=0;
    blue_value=0;
    flag_color = 0;
        
}

//! Protocol Manager state machine implementation.
/*! 
	This task receives data from SCI using sci_read_byte(), if a valid frame is received color manager is updated.
    Five States are implemented, new commands can be added on "PM_READ_CMD" state.
*/
void protocolm_task(void)
{
	int8_t data;
		
	
	data = sci_read_byte();
	
	if(data != -1)
	{
		switch (protocolm_state_machine)
		{
			case PM_IDLE:
				
				if(data == SCI_START)
				{
					protocolm_state_machine = PM_READ_ADDRESS;	
					flag_color=0;
				}
				
			break;
		
			case PM_READ_ADDRESS:
				if(data==gpio_get_address())
				{
					protocolm_state_machine = PM_READ_CMD;	
				}
				else
				{
					protocolm_state_machine = PM_IDLE;	
				}
			break;
		
			case PM_READ_CMD:
				
				switch(data)
				{
					case SCI_CMD_LIT:
						protocolm_state_machine = PM_READ_COLORS;	
					break;
				
					default://new commands to be implemented
						protocolm_state_machine = PM_IDLE;
				}
			
			break;
		
			case PM_READ_COLORS:
				
				if(flag_color==0)
				{
					red_value=data;
					flag_color++;	
				}
				else if(flag_color==1)
				{
					green_value=data;
					flag_color++;	
				}
				else if(flag_color==2)
				{
					blue_value=data;
					flag_color=0;
					protocolm_state_machine = PM_READ_END;	
				}

			break;
		
			case PM_READ_END:
			
				if(data==SCI_END)
				{
					colorm_rcv_value(red_value,green_value,blue_value,CM_CMD_LIT);
				}
				protocolm_state_machine = PM_IDLE;	
					
			break;

			}
	}

	
	
}
